package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.messages.Messages;
import gov.va.med.mhv.foundation.web.xwork.AbstractBaseActionSupport;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.service.AdminService;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@SuppressWarnings("serial")
public abstract class BaseSMAdminAction extends AbstractBaseActionSupport {

	private static final Log LOG = LogFactory.getLog(BaseSMAdminAction.class);

	// Session attribute names
	public final static String CURRENT_USER = "user";

	public static final String SESSION_ATTRIBUTE_LOGIN_ERRORS = 
		BaseSMAdminAction.class.getName() + ".loginErrors";

	private AdminService adminService = null;
	private FacilityService facilityService = null;

	/**
	 * Subclasses overriding this method should call super.prepare()
	 */
	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
			.getWebApplicationContext(ServletActionContext.getServletContext());
		setAdminService((AdminService)ctx.getBean("adminService"));
		setFacilityService((FacilityService)ctx.getBean("facilityService"));
	}

	public Log getLog() {
		return LOG;
	}

	/**
	 * Gets the value of a request parameter
	 * @param paramName
	 * @return
	 * @deprecated Create a member variable with the name of the parameter 
	 *    instead. OpenSymphony will set the member variable.
	 */
	public String getParameter(String paramName) {
		return getRequest().getParameter(paramName);
	}

	/**
	 * Returns a list of strings for values of this parameter.  Returns
	 * a null if there is no such parameter.
	 * @param paramName
	 * @return
	 * @deprecated Create a member variable with the name of the parameter 
	 *    instead. OpenSymphony will set the member variable.
	 */
	public String[] getParameterValues(String paramName) {
		return getRequest().getParameterValues(paramName);
	}

	/**
	 * Returns a list of strings for values of this parameter.  Returns
	 * an empty list if there is no such parameter.  Never returns null.
	 * @param paramName
	 * @return
	 * @deprecated Create a member variable with the name of the parameter 
	 *    instead. OpenSymphony will set the member variable.
	 */
	public List<String> getParameterValueList(String paramName) {
		List<String> result = new ArrayList<String>();
		String[] values = getRequest().getParameterValues(paramName);
		if (values != null) {
			for(String val : values) {
				result.add(val);
			}
		}
		return result;
	}

	public Boolean getParameterAsBoolean(String paramName) {
		return new Boolean(getRequest().getParameter(paramName));
	}
	
	public Long getParameterAsLong(String paramName) {
		return stringToLong(getRequest().getParameter(paramName), null,
			"parameter");
	}

	protected Long stringToLong(String value,  
		Long defaultValue) 
	{
		return stringToLong(value, defaultValue, null);
	}
	protected Long stringToLong(String value, Long defaultValue, String name) {
		try {
			return new Long(value);
		} catch (Exception e) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Error parsing " + ((name != null) ? name + " " : "")
					+ "value to a Long '" + value + "'", e);
			}
			return defaultValue;
		}
	}

	public void setAttribute(String attrName, Object o){
		getRequest().setAttribute(attrName, o);
	}


	public Object getSessionAttribute(String attrName) {
		return getRequest().getSession().getAttribute(attrName);
	}

	public void setSessionAttribute(String attrName, Object value) {
		getRequest().getSession().setAttribute(attrName, value);
	}

	public void removeSessionAttribute(String attrName) {
		getRequest().getSession().removeAttribute(attrName);
	}

	public Administrator getCurrentUser() {
		return (Administrator)getSessionAttribute(CURRENT_USER);
	}

	public String doNothing() {
		return SUCCESS;
	}

	/**
	 * Returns a collection of VISNs where the current user can
	 * administer anything within the visn.  This could be the entire
	 * VISN or just one facility.
	 */
	public Collection<Facility> getAdministeredVisns() {
		Administrator admin = this.getCurrentUser();
		if (admin.isNational()) {
			return getFacilityService().getVisnList().getCollection();
		} else {
			Collection<Long> visnIds = new HashSet<Long>();
			Collection<Facility> result = new TreeSet<Facility>();
			// Explicitly allowed VISNs
			for(Facility visn : admin.getVisns()) {
				result.add(visn);
				visnIds.add(visn.getId());
			}
			// VISNs for which the user can administer one or more facilities
			for(Facility f : admin.getFacilities()){
				if (visnIds.add(f.getVisnId())) {
					result.add(getFacilityService().getFacility(f.getVisnId()).
						getPayload());
				}
			}
			return result;
		}
	}

	/**
	 * Returns a collection of facilities within the given VISN that
	 * the current user can administer
	 * @param visn
	 * @return
	 */
	public Collection<Facility> getAdministeredFacilitiesInVisn(Facility visn) {
		if (visn == null) {
			return new TreeSet<Facility>();
		}
		Administrator user = getCurrentUser();
		if (user.isNational() || isVisnAdministrator(visn)) {
			return getFacilityService().getFacilitiesForVisn(visn).
				getCollection();
		} 
		Set<Facility> result = new TreeSet<Facility>(Facility.
			FACILITY_BY_NAME_SORTER);
		Long targetVisnId = visn.getId();
		for(Facility f : user.getFacilities()) {
			if (f.getVisnId().equals(targetVisnId)) {
				result.add(f);
			}
		}
		return result;
	}
	
	public AdminService getAdminService() {
		return adminService;
	}

	public void setAdminService(AdminService adminService) {
		this.adminService = adminService;
	}

	public FacilityService getFacilityService() {
		return facilityService;
	}

	public void setFacilityService(FacilityService facilityService) {
		this.facilityService = facilityService;
	}

	protected UserManagementService getUserManagementService() {
		return (UserManagementService) getBean("userManagementService");
	}

	protected TriageGroupService getTriageGroupService() {
		return (TriageGroupService) getBean("triageGroupService");
	}

    
	/**
	 * Handles messages in the Messages instance by adding them as an 
	 * ActionErrors (Error Messages) or an ActionMessage (Informational 
	 * Messages) and return true if the instance has any error messages.
	 * @param response The Messages instance to check (null-safe)
	 * @return true, when the response had any error messages; false otherwise.
	 * @deprecated Use {@link #handleMessages(Messages)} instead
	 */
	protected boolean handleErrorMessages(Messages messages) {
		return handleMessages(messages);
	}

	protected boolean isVisnAdministrator(Facility visn) {
		Administrator admin = getCurrentUser();
		if (admin.getVisns() == null) {
			return false;
		}
		for (Facility f: admin.getVisns()) {
			if (visn.getId().equals(f.getId())) {
				return true;
			}
		}
		return false;
	}
	
}
